package com.bycom.versapro.MenuTypes.RSS.UserInterface;

import static com.bycom.versapro.Serializables.Constant.adMobHelper;
import static com.bycom.versapro.Serializables.Constant.appConfig;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.transition.Fade;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.airbnb.lottie.LottieAnimationView;
import com.bycom.versapro.MenuTypes.WordPress.Adapters.WPPostAdapter;
import com.bycom.versapro.R;
import com.bycom.versapro.MenuTypes.RSS.Adapters.RSSAdapter;
import com.bycom.versapro.MenuTypes.RSS.Serializables.RSSItem;
import com.bycom.versapro.MenuTypes.RSS.API.RSSParser;
import com.bycom.versapro.Utils.AdMobHelper;
import com.bycom.versapro.Utils.AppUtil;
import com.facebook.shimmer.ShimmerFrameLayout;
import com.google.android.gms.ads.admanager.AdManagerAdView;

import java.util.ArrayList;


@SuppressLint("SetJavaScriptEnabled")
public class RSSFeedFragment extends Fragment {



    String RSS_URL;
    AppCompatActivity activity;
    View ll_error;
    RecyclerView rv_rss;
    ShimmerFrameLayout shimmerFrameLayout;
    SwipeRefreshLayout swipeRefreshLayout;
    ArrayList<RSSItem> rssItemArrayList = new ArrayList<>();
    TextView tv_error_desc,tv_error_title;
    LottieAnimationView lottieAnimationView;


    RSSAdapter adapter;


    public RSSFeedFragment(){
    }



    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_rss_feed, container, false);

    }


    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);


        setEnterTransition(new Fade());
        setExitTransition(new Fade());

        activity = (AppCompatActivity) requireActivity();

        if(getArguments()!=null) RSS_URL = getArguments().getString("BASE_URL","");


        ll_error = view.findViewById(R.id.ll_error);
        shimmerFrameLayout = view.findViewById(R.id.shimmer);
        rv_rss = view.findViewById(R.id.rv_rss);
        swipeRefreshLayout = view.findViewById(R.id.swipeRefresh);
        tv_error_desc = view.findViewById(R.id.tv_error_desc);
        tv_error_title = view.findViewById(R.id.tv_error_title);
        lottieAnimationView = view.findViewById(R.id.lottie);



        swipeRefreshLayout.setOnRefreshListener(this::fetchData);


        fetchData();





    }


    private void fetchData(){
        adMobHelper.getInterstitialAdManager().showAd(activity);
        rv_rss.setVisibility(View.GONE);
        shimmerFrameLayout.setVisibility(View.VISIBLE);
        shimmerFrameLayout.startShimmer();
        ll_error.setVisibility(View.GONE);


        new Thread(() -> RSSParser.parseRssFeed(RSS_URL, new RSSParser.RSSFeedCallback() {
            @Override
            public void onSuccess(ArrayList<RSSItem> rssItems) {
                activity.runOnUiThread(() -> {
                    rssItemArrayList = rssItems;
                    showData();
                });
            }

            @Override
            public void onFailed() {
                activity.runOnUiThread(() -> {
                    swipeRefreshLayout.setEnabled(false);
                    shimmerFrameLayout.stopShimmer();
                    shimmerFrameLayout.setVisibility(View.GONE);
                    showError();

                });
            }
        })).start();
    }



    private void showData(){
        rv_rss.setVisibility(View.VISIBLE);
        shimmerFrameLayout.stopShimmer();
        shimmerFrameLayout.setVisibility(View.GONE);
        ll_error.setVisibility(View.GONE);
        swipeRefreshLayout.setRefreshing(false);

        LinearLayoutManager layoutManager = new LinearLayoutManager(activity);
        rv_rss.setLayoutManager(layoutManager);

        adapter = new RSSAdapter(activity,this,rssItemArrayList);
        rv_rss.setAdapter(adapter);


        if(rssItemArrayList.size()>1) {
            activity.runOnUiThread(() -> insertAdView(1));
        }



    }

    private void insertAdView(int position){


        adMobHelper.getBannerAdManager().getAnchoredAdView(activity, new AdMobHelper.BannerAdCallback() {
            @Override
            public void onSuccess(AdManagerAdView adManagerAdView) {
                rssItemArrayList.add(position, new RSSItem() {{
                    setType(WPPostAdapter.ITEM_BANNER_AD);
                    setAdView(adManagerAdView);
                }});
                adapter.notifyItemInserted(position);

                if(rssItemArrayList.size()>position+10){
                    insertAdView(position+10);
                }
            }

            @Override
            public void onFailed() {

            }
        });

    }

    public void showError(){
        if(AppUtil.isNoInternet(activity)){

            lottieAnimationView.setAnimation(R.raw.no_internet);
            tv_error_title.setText(R.string.network_error);
            tv_error_desc.setText(R.string.no_internet_error_message);
            ll_error.setVisibility(View.VISIBLE);

        }else {


            lottieAnimationView.setAnimation(R.raw.error);
            tv_error_title.setText(R.string.not_found);
            tv_error_desc.setText(R.string.no_post_error_message);
            ll_error.setVisibility(View.VISIBLE);

        }
    }




}